% MUTATION Mutation function.
%
% The arguments to the function are
%     PARENTS: Parents chosen by the selection function
%     OPTIONS: Options structure created from GAOPTIMSET
%     NVARS: Number of variables
%     FITNESSFCN: Fitness function
%     STATE: State structure used by the GA solver
%     THISSCORE: Matrix of scores of the current population
%     THISPOPULATION: Matrix of individuals in the current population
%     MUTATIONRATE: Rate of mutation
function mutationChildren = mutation(parents ,options,NVARS, ...
    FitnessFcn, state, thisScore,thisPopulation, mutationRate)

% Initialize the cell array to mutated children
mutationChildren = cell(length(parents),1);

% Mutation for each parent 
for i=1:length(parents)

    % Obtain the parent
    parent = thisPopulation{parents(i)};

    % Select randomly the sequence to mutate
    gaps = (parent.msa=='*');
    seqs = find(sum(gaps')>0); % Avoid sequences without gaps
    seq = seqs(randi(length(seqs))); 
    pos_gaps = find(parent.msa(seq,:)=='*');
    
    % Select randomly the gap group to shift
    inits = pos_gaps(diff([-1 pos_gaps])>1); % Find non-consecutive gaps
    pos_init = randi(length(inits));
    ini = inits(pos_init);
    if(pos_init ~= length(inits))
        fin = pos_gaps(find(pos_gaps==inits(pos_init+1))-1);
    else
        fin = pos_gaps(length(pos_gaps));
    end

    % Choose randomly the position where gaps are relocated
    pos_jump = randi(length(parent.msa) - fin + ini);
    jump = pos_jump + fin - ini;
    if(ini>1 && fin<length(parent.msa))
        if(pos_jump > ini)
            positions = [1:ini-1 fin+1:jump ini:fin jump+1:length(parent.msa)];
        else
            positions = [1:pos_jump-1 ini:fin pos_jump:ini-1 fin+1:length(parent.msa)];    
        end
    else
        if(ini==1)
            positions = [fin+1:jump ini:fin jump+1:length(parent.msa)];
        elseif(fin==length(parent.msa))
            positions = [1:pos_jump-1 ini:fin pos_jump:ini-1];
        end
    end

    child = parent;
    sequence = child.msa(seq,:);

    % Change the sequence with the changed gap section
    child.msa(seq,:) = sequence(positions);
    child.codification = codify_chromosome(child.msa);

    % Remove column with all gaps
    all_gaps = sum(child.msa~='*')==0;
    child.msa = child.msa(:,~all_gaps); 
    child.codification = child.codification(:,~all_gaps);

    % Save in the cell array the new child
    mutationChildren{i} = child;
end


